/*
 * Decompiled with CFR 0.152.
 */
package jade.domain;

import jade.content.ContentManager;
import jade.content.abs.AbsAgentAction;
import jade.content.abs.AbsIRE;
import jade.content.abs.AbsPredicate;
import jade.domain.DFMemKB;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.FIPAManagementOntology;
import jade.domain.FIPAAgentManagement.FailureException;
import jade.domain.FIPAAgentManagement.NotUnderstoodException;
import jade.domain.FIPAAgentManagement.RefuseException;
import jade.domain.FIPAAgentManagement.Search;
import jade.domain.FIPAAgentManagement.SearchConstraints;
import jade.domain.KBManagement.KB;
import jade.lang.acl.ACLMessage;
import jade.proto.SubscriptionResponder;
import jade.util.leap.ArrayList;
import jade.util.leap.List;
import java.util.Enumeration;

class KBSubscriptionManager
implements SubscriptionResponder.SubscriptionManager {
    KB kBase;
    ContentManager cm;

    public KBSubscriptionManager(KB k) {
        this.kBase = k;
    }

    public void setContentManager(ContentManager c) {
        this.cm = c;
    }

    public boolean register(SubscriptionResponder.Subscription sub) throws RefuseException, NotUnderstoodException {
        DFAgentDescription dfdTemplate = null;
        SearchConstraints constraints = null;
        AbsIRE absIota = null;
        try {
            ACLMessage subMessage = sub.getMessage();
            absIota = (AbsIRE)this.cm.extractAbsContent(subMessage);
            AbsPredicate absResult = absIota.getProposition();
            AbsAgentAction absAction = (AbsAgentAction)absResult.getAbsObject("action");
            AbsAgentAction absSearch = (AbsAgentAction)absAction.getAbsObject("action");
            Search search = (Search)FIPAManagementOntology.getInstance().toObject(absSearch);
            dfdTemplate = (DFAgentDescription)search.getDescription();
            constraints = search.getConstraints();
            this.kBase.subscribe(dfdTemplate, sub);
        }
        catch (Exception e) {
            throw new NotUnderstoodException(e.getMessage());
        }
        List results = this.kBase.search(dfdTemplate, -1);
        if (results.size() > 0) {
            this.notify(sub, results, absIota);
            return true;
        }
        return false;
    }

    public boolean deregister(SubscriptionResponder.Subscription sub) throws FailureException {
        this.kBase.unsubscribe(sub);
        return false;
    }

    private DFAgentDescription getDFAgentDescriptionFromACL(ACLMessage aclM) {
        DFAgentDescription dfd = null;
        try {
            AbsIRE absIota = (AbsIRE)this.cm.extractAbsContent(aclM);
            AbsPredicate absResult = absIota.getProposition();
            AbsAgentAction absAction = (AbsAgentAction)absResult.getAbsObject("action");
            AbsAgentAction absSearch = (AbsAgentAction)absAction.getAbsObject("action");
            Search search = (Search)FIPAManagementOntology.getInstance().toObject(absSearch);
            dfd = (DFAgentDescription)search.getDescription();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dfd;
    }

    void handleChange(DFAgentDescription dfd, DFAgentDescription oldDfd) {
        Enumeration e = this.kBase.getSubscriptions();
        while (e.hasMoreElements()) {
            SubscriptionResponder.Subscription sub = (SubscriptionResponder.Subscription)e.nextElement();
            DFAgentDescription template = this.getDFAgentDescriptionFromACL(sub.getMessage());
            if (!DFMemKB.compare(template, dfd) && (oldDfd == null || !DFMemKB.compare(template, oldDfd))) continue;
            ArrayList results = new ArrayList();
            results.add(dfd);
            ACLMessage aclSub = sub.getMessage();
            AbsIRE absIota = null;
            try {
                absIota = (AbsIRE)this.cm.extractAbsContent(aclSub);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.notify(sub, results, absIota);
        }
    }

    private void notify(SubscriptionResponder.Subscription sub, List results, AbsIRE absIota) {
        try {
            ACLMessage notification = sub.getMessage().createReply();
            notification.addUserDefinedParameter("JADE-ignore-failure", "true");
            notification.setPerformative(7);
            AbsPredicate absEquals = new AbsPredicate("=");
            absEquals.set("left", absIota);
            absEquals.set("right", FIPAManagementOntology.getInstance().fromObject(results));
            this.cm.fillContent(notification, absEquals);
            sub.notify(notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

